# coding: iso-8859-1
# Permet de grer des fichiers dans un script Ruby

begin
  require "Base64"
rescue Exception 

end

class Archive

  F_ARCHIVE = "./Environnement/archive.rb" #if defined?(F_ARCHIVE) == false
  STR = '$archive["%s"]="%s"'+"\n"*2 #if defined?(STR) == false
  
  def self.initialize
    #p "initi"
    string = "$archive = {}"+"\n"*3
    DA::file_write(F_ARCHIVE, string, "w")

  end


  # Ajoute le fichier  la liste de ceux prsents dans l'archive
  def self.dump(vir_file)
    # On vrifie qu'il s'agisse d'un fichier virtuel
    if vir_file.is_a?(Virtual_File) == false
      vir_file = Virtual_File.new(vir_file)
    end
    #p vir_file.name
    # On rcupre le contenu du fichier
    c = vir_file.contenu_r
    #p c.size
    # On l'encode en base 64
    c = Base64::encode64(c)
    #p c.size
    #string = "#{DEB}#{@name}*#{c}#{FIN}"
    # On ajoute la string au fichier
    string = sprintf(STR, vir_file.path, c)

    DA::file_write(F_ARCHIVE, string, "a")

  end
  



  def self.open
    Kernel::require(F_ARCHIVE)
  end


  def self.open?
    return ($archive != nil)
  end


  def self.close
    $archive = nil
  end


  # Lit un fichier dans l'archive
  def self.load(name)
    self.verifier(name)
    return self.decode(name)
  end

  def self.read(name)
    self.verifier(name)
    binary = self.decode(name)
    binary.gsub!("\r\n", "\n")
    #p binary[0..100]
    return binary
  end

  # Retourne le contenu du fichier en question, dcod.
  # A n'utiliser qu'en interne
  def self.decode(name)
    #p name, $archive[name].size, Base64::decode64($archive[name]).size
    return Base64::decode64($archive[name])
  end
  
  # Vrification des condititions sine qua non d'accs  un fichier
  def self.verifier(name)
    # On s'assure que l'archive est bien ouverte
    if self.open? == false
      self.open
    end
    # On vrifie que le fichier existe
    if $archive[name] == nil
      raisee("Le fichier %s n'existe pas dans l'archive.", name)
    end
  end


  # Ecrit un fichier de l'achive sur le disque
  #  name : nom du fichier dans l'archive
  #  name2 : nom o crire sur le disque
  #
  def self.write_file(name, name2=name)
    self.verifier(name)
    contenu = self.decode(name)
    #p "taille avant : ", contenu.size
    DA::file_write(name2, contenu, "wb")
    #p "taille apres : ", File.size(name2)
  end


  # Ecrit un fichier de l'achive sur le disque
  #  name : nom du fichier dans l'archive
  #  name2 : nom o crire sur le disque
  #
  def self.write_file_normal(name, name2=name)
    self.verifier(name)
    contenu = self.read(name)
    #p "taille avant : ", contenu.size
    DA::file_write(name2, contenu, "w")
    #p "taille apres : ", File.size(name2)
  end


end